<?php
/**
 * Single Post Template
 *
 * @package Amir_Ahmed
 */

get_header();
?>

<header class="page-header">
    <div class="container">
        <h1 class="page-title"><?php the_title(); ?></h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<article id="post-<?php the_ID(); ?>" <?php post_class('single-post section'); ?>>
    <div class="container">
        <div class="single-post-content" style="max-width: 800px; margin: 0 auto;">
            <!-- Post Meta -->
            <div class="post-meta mb-4" style="display: flex; gap: 20px; font-size: 0.9rem; color: var(--color-gray-dark);">
                <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="vertical-align: middle; margin-right: 5px;"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>
                    <?php echo get_the_date(); ?>
                </span>
                <?php if (has_category()) : ?>
                <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="vertical-align: middle; margin-right: 5px;"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"></path></svg>
                    <?php the_category(', '); ?>
                </span>
                <?php endif; ?>
            </div>

            <!-- Featured Image -->
            <?php if (has_post_thumbnail()) : ?>
            <div class="post-featured-image mb-4" style="border-radius: 10px; overflow: hidden;">
                <?php the_post_thumbnail('large'); ?>
            </div>
            <?php endif; ?>

            <!-- Post Content -->
            <div class="post-content" style="font-size: 1.1rem; line-height: 1.8;">
                <?php the_content(); ?>
            </div>

            <!-- Post Tags -->
            <?php if (has_tag()) : ?>
            <div class="post-tags mt-4" style="display: flex; gap: 10px; flex-wrap: wrap;">
                <?php the_tags('<span class="tag-label" style="font-weight: 600;">Tags:</span> ', ' '); ?>
            </div>
            <?php endif; ?>

            <!-- Post Navigation -->
            <nav class="post-navigation mt-5" style="display: flex; justify-content: space-between; padding-top: 30px; border-top: 1px solid var(--color-gray);">
                <div class="nav-previous">
                    <?php previous_post_link('%link', '&laquo; Previous Post'); ?>
                </div>
                <div class="nav-next">
                    <?php next_post_link('%link', 'Next Post &raquo;'); ?>
                </div>
            </nav>
        </div>
    </div>
</article>

<!-- Related Posts -->
<?php
$related_args = array(
    'post_type'      => 'post',
    'posts_per_page' => 3,
    'post__not_in'   => array(get_the_ID()),
    'orderby'        => 'rand',
);

$categories = get_the_category();
if ($categories) {
    $related_args['category__in'] = array($categories[0]->term_id);
}

$related_query = new WP_Query($related_args);

if ($related_query->have_posts()) :
?>
<section class="section bg-gray">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Related Articles</h2>
        </div>
        <div class="posts-grid">
            <?php while ($related_query->have_posts()) : $related_query->the_post(); ?>
            <article class="post-card">
                <div class="post-image">
                    <?php if (has_post_thumbnail()) : ?>
                        <a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail('post-thumb'); ?>
                        </a>
                    <?php else : ?>
                        <div style="background: var(--color-gray-dark); width: 100%; height: 220px;"></div>
                    <?php endif; ?>
                </div>
                <div class="post-content">
                    <div class="post-meta">
                        <span><?php echo get_the_date(); ?></span>
                    </div>
                    <h3 class="post-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h3>
                    <a href="<?php the_permalink(); ?>" class="read-more">Read More</a>
                </div>
            </article>
            <?php endwhile; ?>
        </div>
    </div>
</section>
<?php
wp_reset_postdata();
endif;
?>

<?php get_footer(); ?>
