<?php
/**
 * Single Portfolio Template
 *
 * @package Amir_Ahmed
 */

get_header();

$categories = get_the_terms(get_the_ID(), 'portfolio_category');
$category_name = $categories && !is_wp_error($categories) ? $categories[0]->name : '';
?>

<header class="page-header">
    <div class="container">
        <?php if ($category_name) : ?>
        <p class="section-subtitle" style="color: var(--color-primary);"><?php echo esc_html($category_name); ?></p>
        <?php endif; ?>
        <h1 class="page-title"><?php the_title(); ?></h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<article id="portfolio-<?php the_ID(); ?>" <?php post_class('single-portfolio section'); ?>>
    <div class="container">
        <!-- Featured Image -->
        <?php if (has_post_thumbnail()) : ?>
        <div class="portfolio-featured-image mb-5" style="border-radius: 10px; overflow: hidden;">
            <?php the_post_thumbnail('portfolio-large'); ?>
        </div>
        <?php endif; ?>

        <div class="portfolio-content-wrapper" style="display: grid; grid-template-columns: 2fr 1fr; gap: 60px;">
            <!-- Main Content -->
            <div class="portfolio-main-content">
                <h2>About This Project</h2>
                <div class="portfolio-description" style="font-size: 1.1rem; line-height: 1.8;">
                    <?php the_content(); ?>
                </div>
            </div>

            <!-- Project Details Sidebar -->
            <div class="portfolio-sidebar">
                <div class="project-details" style="background: var(--color-gray); padding: 30px; border-radius: 10px;">
                    <h3 style="margin-bottom: 25px;">Project Details</h3>

                    <?php if ($category_name) : ?>
                    <div class="detail-item" style="margin-bottom: 20px;">
                        <h4 style="font-size: 0.85rem; text-transform: uppercase; letter-spacing: 1px; color: var(--color-gray-dark); margin-bottom: 5px;">Category</h4>
                        <p style="margin: 0; font-weight: 500;"><?php echo esc_html($category_name); ?></p>
                    </div>
                    <?php endif; ?>

                    <div class="detail-item" style="margin-bottom: 20px;">
                        <h4 style="font-size: 0.85rem; text-transform: uppercase; letter-spacing: 1px; color: var(--color-gray-dark); margin-bottom: 5px;">Date</h4>
                        <p style="margin: 0; font-weight: 500;"><?php echo get_the_date('F Y'); ?></p>
                    </div>

                    <?php
                    $project_client = get_post_meta(get_the_ID(), 'project_client', true);
                    if ($project_client) :
                    ?>
                    <div class="detail-item" style="margin-bottom: 20px;">
                        <h4 style="font-size: 0.85rem; text-transform: uppercase; letter-spacing: 1px; color: var(--color-gray-dark); margin-bottom: 5px;">Client</h4>
                        <p style="margin: 0; font-weight: 500;"><?php echo esc_html($project_client); ?></p>
                    </div>
                    <?php endif; ?>

                    <?php
                    $project_url = get_post_meta(get_the_ID(), 'project_url', true);
                    if ($project_url) :
                    ?>
                    <div class="detail-item">
                        <a href="<?php echo esc_url($project_url); ?>" target="_blank" class="btn btn-primary w-100" style="justify-content: center;">View Project</a>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Share -->
                <div class="project-share mt-4" style="background: var(--color-gray); padding: 30px; border-radius: 10px;">
                    <h4 style="margin-bottom: 15px;">Share This Project</h4>
                    <div class="share-links" style="display: flex; gap: 10px;">
                        <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode(get_permalink()); ?>&text=<?php echo urlencode(get_the_title()); ?>" target="_blank" style="width: 45px; height: 45px; background: var(--color-dark); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 3a10.9 10.9 0 0 1-3.14 1.53 4.48 4.48 0 0 0-7.86 3v1A10.66 10.66 0 0 1 3 4s-4 9 5 13a11.64 11.64 0 0 1-7 2c9 5 20 0 20-11.5a4.5 4.5 0 0 0-.08-.83A7.72 7.72 0 0 0 23 3z"></path></svg>
                        </a>
                        <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode(get_permalink()); ?>&title=<?php echo urlencode(get_the_title()); ?>" target="_blank" style="width: 45px; height: 45px; background: var(--color-dark); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z"></path><rect x="2" y="9" width="4" height="12"></rect><circle cx="4" cy="4" r="2"></circle></svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Project Navigation -->
        <nav class="portfolio-navigation mt-5" style="display: flex; justify-content: space-between; padding-top: 30px; border-top: 1px solid var(--color-gray);">
            <div class="nav-previous">
                <?php previous_post_link('%link', '&laquo; Previous Project', false, '', 'portfolio_category'); ?>
            </div>
            <div class="nav-next">
                <?php next_post_link('%link', 'Next Project &raquo;', false, '', 'portfolio_category'); ?>
            </div>
        </nav>
    </div>
</article>

<!-- More Projects -->
<?php
$related_args = array(
    'post_type'      => 'portfolio',
    'posts_per_page' => 3,
    'post__not_in'   => array(get_the_ID()),
    'orderby'        => 'rand',
);

if ($categories && !is_wp_error($categories)) {
    $related_args['tax_query'] = array(
        array(
            'taxonomy' => 'portfolio_category',
            'terms'    => $categories[0]->term_id,
        ),
    );
}

$related_query = new WP_Query($related_args);

if ($related_query->have_posts()) :
?>
<section class="section section-dark">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">More Projects</h2>
        </div>
        <div class="portfolio-grid">
            <?php while ($related_query->have_posts()) : $related_query->the_post();
                $cats = get_the_terms(get_the_ID(), 'portfolio_category');
                $cat_name = $cats && !is_wp_error($cats) ? $cats[0]->name : '';
            ?>
            <div class="portfolio-item">
                <?php if (has_post_thumbnail()) : ?>
                    <?php the_post_thumbnail('portfolio-thumb'); ?>
                <?php else : ?>
                    <div style="background: linear-gradient(135deg, var(--color-primary) 0%, #333 100%); width: 100%; height: 300px;"></div>
                <?php endif; ?>
                <div class="portfolio-overlay">
                    <?php if ($cat_name) : ?>
                    <span class="portfolio-category"><?php echo esc_html($cat_name); ?></span>
                    <?php endif; ?>
                    <h3 class="portfolio-title"><?php the_title(); ?></h3>
                </div>
                <a href="<?php the_permalink(); ?>" class="portfolio-link" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 10;"></a>
            </div>
            <?php endwhile; ?>
        </div>
    </div>
</section>
<?php
wp_reset_postdata();
endif;
?>

<style>
@media (max-width: 992px) {
    .portfolio-content-wrapper {
        grid-template-columns: 1fr !important;
    }
}
</style>

<?php get_footer(); ?>
