<?php
/**
 * Template Name: Contact Page
 *
 * @package Amir_Ahmed
 */

get_header();

$email = get_theme_mod('contact_email', 'hello@amirahmed.com');
$location = get_theme_mod('contact_location', 'Dubai, United Arab Emirates');
?>

<header class="page-header">
    <div class="container">
        <h1 class="page-title">Get In <span>Touch</span></h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<section class="section">
    <div class="container">
        <div class="contact-content">
            <!-- Contact Information -->
            <div class="contact-info animate-fadeInUp">
                <h2>Let's Start a Conversation</h2>
                <p>Have a project in mind or just want to say hello? I'd love to hear from you. Fill out the form or reach out through any of the channels below.</p>

                <div class="contact-details">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>
                        </div>
                        <div class="contact-text">
                            <h4>Email</h4>
                            <p><a href="mailto:<?php echo esc_attr($email); ?>"><?php echo esc_html($email); ?></a></p>
                        </div>
                    </div>

                    <div class="contact-item">
                        <div class="contact-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>
                        </div>
                        <div class="contact-text">
                            <h4>Location</h4>
                            <p><?php echo esc_html($location); ?></p>
                        </div>
                    </div>

                    <div class="contact-item">
                        <div class="contact-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                        </div>
                        <div class="contact-text">
                            <h4>Business Hours</h4>
                            <p>Sun - Thu: 9:00 AM - 6:00 PM</p>
                        </div>
                    </div>
                </div>

                <!-- Social Links -->
                <div class="contact-social mt-4">
                    <h4>Follow Me</h4>
                    <?php amir_ahmed_social_links(); ?>
                </div>
            </div>

            <!-- Contact Form -->
            <div class="contact-form-wrapper animate-fadeInUp delay-2">
                <form id="contact-form" class="contact-form" method="post">
                    <div class="form-group">
                        <label for="name">Your Name *</label>
                        <input type="text" id="name" name="name" required placeholder="John Doe">
                    </div>

                    <div class="form-group">
                        <label for="email">Email Address *</label>
                        <input type="email" id="email" name="email" required placeholder="john@example.com">
                    </div>

                    <div class="form-group">
                        <label for="subject">Subject</label>
                        <input type="text" id="subject" name="subject" placeholder="Project Inquiry">
                    </div>

                    <div class="form-group">
                        <label for="message">Your Message *</label>
                        <textarea id="message" name="message" required placeholder="Tell me about your project..."></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary w-100">
                        Send Message
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="22" y1="2" x2="11" y2="13"></line><polygon points="22 2 15 22 11 13 2 9 22 2"></polygon></svg>
                    </button>

                    <div id="form-message" class="form-message" style="display: none;"></div>
                </form>
            </div>
        </div>
    </div>
</section>

<style>
.contact-social h4 {
    margin-bottom: 15px;
}

.form-message {
    margin-top: 20px;
    padding: 15px;
    border-radius: 5px;
    text-align: center;
}

.form-message.success {
    background-color: #d4edda;
    color: #155724;
}

.form-message.error {
    background-color: #f8d7da;
    color: #721c24;
}

.btn.w-100 {
    width: 100%;
    justify-content: center;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('contact-form');
    const formMessage = document.getElementById('form-message');

    if (form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(form);
            formData.append('action', 'contact_form');
            formData.append('nonce', amirAhmed.nonce);

            fetch(amirAhmed.ajaxurl, {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                formMessage.style.display = 'block';
                if (data.success) {
                    formMessage.className = 'form-message success';
                    formMessage.textContent = data.data.message;
                    form.reset();
                } else {
                    formMessage.className = 'form-message error';
                    formMessage.textContent = data.data.message;
                }
            })
            .catch(error => {
                formMessage.style.display = 'block';
                formMessage.className = 'form-message error';
                formMessage.textContent = 'An error occurred. Please try again.';
            });
        });
    }
});
</script>

<?php get_footer(); ?>
