<?php
/**
 * Template Name: About Page
 *
 * @package Amir_Ahmed
 */

get_header();

$hero_image_id = get_theme_mod('hero_image');
?>

<header class="page-header">
    <div class="container">
        <h1 class="page-title">About <span>Me</span></h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<!-- Biography Section -->
<section class="section">
    <div class="container">
        <div class="about-content">
            <div class="about-image animate-fadeInUp">
                <?php if ($hero_image_id) : ?>
                    <?php echo wp_get_attachment_image($hero_image_id, 'large'); ?>
                <?php else : ?>
                    <div class="about-placeholder" style="background: var(--color-gray); width: 100%; height: 600px; border-radius: 10px;"></div>
                <?php endif; ?>
            </div>
            <div class="about-text animate-fadeInUp delay-2">
                <h2 class="text-primary">AMIR</h2>
                <h2 style="font-weight: 300; margin-top: -15px;">AHMED</h2>
                <p style="font-size: 1.2rem; margin-bottom: 30px;">Amir Ahmed Omar Mohamed is an entrepreneur, interdisciplinary artist, and creative strategist based in the United Arab Emirates. Born in Dubai in 1993, Amir brings over 15 years of hands-on experience across content creation, storytelling, marketing, and creative production.</p>
                <p>His work includes photography, filmmaking, Arabic calligraphy, Hip-hop & music production, podcasting, branding, and digital marketing. He blends art with strategy to create impactful results.</p>
                <p>Amir began his creative journey early, inspired by his father, a visual artist and Arabic calligrapher. By his teenage years, he had already mastered graphic design, photography, and visual storytelling, laying the groundwork for his diverse career.</p>
            </div>
        </div>
    </div>
</section>

<!-- Journey Timeline -->
<section class="section section-dark">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle">My Story</p>
            <h2 class="section-title">Journey Timeline</h2>
        </div>

        <div class="timeline">
            <div class="timeline-item animate-fadeInUp">
                <div class="timeline-marker"></div>
                <div class="timeline-content">
                    <h3>1993</h3>
                    <h4>Born in Dubai</h4>
                    <p>Born in Dubai, United Arab Emirates, into a creative family.</p>
                </div>
            </div>
            <div class="timeline-item animate-fadeInUp delay-1">
                <div class="timeline-marker"></div>
                <div class="timeline-content">
                    <h3>2008</h3>
                    <h4>Creative Awakening</h4>
                    <p>Started exploring graphic design, photography, and visual storytelling inspired by father's artistic work.</p>
                </div>
            </div>
            <div class="timeline-item animate-fadeInUp delay-2">
                <div class="timeline-marker"></div>
                <div class="timeline-content">
                    <h3>2013</h3>
                    <h4>Professional Journey Begins</h4>
                    <p>Started professional career in content creation and digital marketing.</p>
                </div>
            </div>
            <div class="timeline-item animate-fadeInUp delay-3">
                <div class="timeline-marker"></div>
                <div class="timeline-content">
                    <h3>Present</h3>
                    <h4>Creative Strategist</h4>
                    <p>Leading creative projects across multiple disciplines with 15+ years of experience.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Philosophy Section -->
<section class="section section-yellow">
    <div class="container">
        <div class="about-content" style="gap: 60px;">
            <div class="about-text animate-fadeInUp">
                <p class="section-subtitle" style="color: var(--color-dark);">Philosophy</p>
                <h2>Clients Choose Results Not Promises</h2>
                <p>We turn bold strategies into measurable impact. Strategy built to deliver, not decorate. Every decision backed by results.</p>
                <p>My approach combines artistic vision with strategic thinking, ensuring that every project not only looks beautiful but also achieves its intended goals.</p>
            </div>
            <div class="philosophy-values animate-fadeInUp delay-2">
                <div class="value-item" style="background: var(--color-white); padding: 30px; border-radius: 10px; margin-bottom: 20px;">
                    <h4>Results-Driven</h4>
                    <p style="margin: 0;">Every project is measured by its impact and outcomes.</p>
                </div>
                <div class="value-item" style="background: var(--color-white); padding: 30px; border-radius: 10px; margin-bottom: 20px;">
                    <h4>Creative Excellence</h4>
                    <p style="margin: 0;">Pushing creative boundaries while maintaining strategic focus.</p>
                </div>
                <div class="value-item" style="background: var(--color-white); padding: 30px; border-radius: 10px;">
                    <h4>Client Partnership</h4>
                    <p style="margin: 0;">Building lasting relationships through collaboration and trust.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Skills Section -->
<section class="section">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle">Expertise</p>
            <h2 class="section-title">Skills & Services</h2>
        </div>
        <div class="services-grid">
            <div class="service-item">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><circle cx="8.5" cy="8.5" r="1.5"></circle><polyline points="21 15 16 10 5 21"></polyline></svg>
                </div>
                <h3 class="service-title">Photography</h3>
                <p>Professional photography with artistic vision</p>
            </div>
            <div class="service-item">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polygon points="23 7 16 12 23 17 23 7"></polygon><rect x="1" y="5" width="15" height="14" rx="2" ry="2"></rect></svg>
                </div>
                <h3 class="service-title">Filmmaking</h3>
                <p>Visual storytelling through video production</p>
            </div>
            <div class="service-item">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 19l7-7 3 3-7 7-3-3z"></path><path d="M18 13l-1.5-7.5L2 2l3.5 14.5L13 18l5-5z"></path></svg>
                </div>
                <h3 class="service-title">Arabic Calligraphy</h3>
                <p>Traditional and modern calligraphy art</p>
            </div>
            <div class="service-item">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 18V5l12-2v13"></path><circle cx="6" cy="18" r="3"></circle><circle cx="18" cy="16" r="3"></circle></svg>
                </div>
                <h3 class="service-title">Music Production</h3>
                <p>Hip-hop and creative music production</p>
            </div>
            <div class="service-item">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 1a3 3 0 0 0-3 3v8a3 3 0 0 0 6 0V4a3 3 0 0 0-3-3z"></path><path d="M19 10v2a7 7 0 0 1-14 0v-2"></path><line x1="12" y1="19" x2="12" y2="23"></line><line x1="8" y1="23" x2="16" y2="23"></line></svg>
                </div>
                <h3 class="service-title">Podcasting</h3>
                <p>Content creation and podcast production</p>
            </div>
            <div class="service-item">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"></circle><line x1="2" y1="12" x2="22" y2="12"></line><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path></svg>
                </div>
                <h3 class="service-title">Digital Marketing</h3>
                <p>Strategic marketing and brand development</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="section section-dark">
    <div class="container text-center">
        <h2 class="section-title mb-3">Let's Work Together</h2>
        <p class="section-description mb-4" style="color: rgba(255,255,255,0.7); max-width: 600px; margin-left: auto; margin-right: auto;">Ready to bring your creative vision to life? Get in touch to discuss your next project.</p>
        <a href="<?php echo esc_url(home_url('/contact')); ?>" class="btn btn-primary">Get In Touch</a>
    </div>
</section>

<style>
/* Timeline Styles */
.timeline {
    position: relative;
    max-width: 800px;
    margin: 0 auto;
    padding-left: 60px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 20px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: var(--color-primary);
}

.timeline-item {
    position: relative;
    margin-bottom: 50px;
}

.timeline-marker {
    position: absolute;
    left: -50px;
    width: 20px;
    height: 20px;
    background: var(--color-primary);
    border-radius: 50%;
    border: 4px solid var(--color-dark);
}

.timeline-content h3 {
    color: var(--color-primary);
    font-size: 1.2rem;
    margin-bottom: 5px;
}

.timeline-content h4 {
    color: var(--color-white);
    margin-bottom: 10px;
}

.timeline-content p {
    color: rgba(255,255,255,0.7);
    margin: 0;
}

@media (max-width: 768px) {
    .timeline {
        padding-left: 40px;
    }

    .timeline::before {
        left: 10px;
    }

    .timeline-marker {
        left: -35px;
        width: 15px;
        height: 15px;
    }
}
</style>

<?php get_footer(); ?>
