<?php
/**
 * Main Index Template
 *
 * @package Amir_Ahmed
 */

get_header();
?>

<header class="page-header">
    <div class="container">
        <h1 class="page-title">
            <?php
            if (is_home()) {
                echo 'Press <span>Room</span>';
            } elseif (is_archive()) {
                the_archive_title();
            } elseif (is_search()) {
                printf(__('Search Results for: %s', 'amir-ahmed'), '<span>' . get_search_query() . '</span>');
            } else {
                echo 'Latest <span>Updates</span>';
            }
            ?>
        </h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<section class="section">
    <div class="container">
        <?php if (have_posts()) : ?>
        <div class="posts-grid">
            <?php while (have_posts()) : the_post(); ?>
            <article id="post-<?php the_ID(); ?>" <?php post_class('post-card'); ?>>
                <div class="post-image">
                    <?php if (has_post_thumbnail()) : ?>
                        <a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail('post-thumb'); ?>
                        </a>
                    <?php else : ?>
                        <div style="background: var(--color-gray); width: 100%; height: 220px;"></div>
                    <?php endif; ?>
                </div>
                <div class="post-content">
                    <div class="post-meta">
                        <span><?php echo get_the_date(); ?></span>
                        <?php if (has_category()) : ?>
                        <span><?php the_category(', '); ?></span>
                        <?php endif; ?>
                    </div>
                    <h3 class="post-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h3>
                    <p class="post-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                    <a href="<?php the_permalink(); ?>" class="read-more">Read More</a>
                </div>
            </article>
            <?php endwhile; ?>
        </div>

        <!-- Pagination -->
        <div class="pagination mt-5">
            <?php
            the_posts_pagination(array(
                'mid_size'  => 2,
                'prev_text' => '&laquo; Previous',
                'next_text' => 'Next &raquo;',
            ));
            ?>
        </div>

        <?php else : ?>
        <div class="no-posts text-center">
            <h2>No posts found</h2>
            <p>It seems we can't find what you're looking for.</p>
        </div>
        <?php endif; ?>
    </div>
</section>

<?php get_footer(); ?>
