<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <?php wp_head(); ?>
</head>
<?php
// Get header customizer settings
$logo_text_line1   = get_theme_mod('logo_text_line1', 'AMIR');
$logo_text_line2   = get_theme_mod('logo_text_line2', 'AHMED');
$show_logo_icon    = get_theme_mod('show_logo_icon', true);
$logo_icon_image   = get_theme_mod('logo_icon_image');
$header_style      = get_theme_mod('header_style', 'light');
$header_sticky     = get_theme_mod('header_sticky', true);
$show_header_cta   = get_theme_mod('show_header_cta', false);
$header_cta_text   = get_theme_mod('header_cta_text', 'Get In Touch');
$header_cta_url    = get_theme_mod('header_cta_url', '/contact');

// Build header classes
$header_classes = array('site-header');
$header_classes[] = 'header-' . $header_style;
if ($header_sticky) {
    $header_classes[] = 'header-sticky';
}
if (!is_front_page()) {
    $header_classes[] = 'scrolled';
}
?>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header class="<?php echo esc_attr(implode(' ', $header_classes)); ?>">
    <div class="container-fluid">
        <div class="header-inner">
            <!-- Logo -->
            <a href="<?php echo esc_url(home_url('/')); ?>" class="site-logo">
                <?php if (has_custom_logo()) : ?>
                    <?php the_custom_logo(); ?>
                <?php else : ?>
                    <?php if ($show_logo_icon) : ?>
                        <div class="logo-icon">
                            <?php if ($logo_icon_image) : ?>
                                <?php echo wp_get_attachment_image($logo_icon_image, 'thumbnail'); ?>
                            <?php else : ?>
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 100 100">
                                    <path fill="currentColor" d="M50 0L58 42L100 50L58 58L50 100L42 58L0 50L42 42Z"/>
                                </svg>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($logo_text_line1 || $logo_text_line2) : ?>
                        <div class="logo-text">
                            <?php if ($logo_text_line1) : ?>
                                <strong><?php echo esc_html($logo_text_line1); ?></strong>
                            <?php endif; ?>
                            <?php if ($logo_text_line2) : ?>
                                <span><?php echo esc_html($logo_text_line2); ?></span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </a>

            <!-- Navigation -->
            <nav class="main-navigation" id="site-navigation">
                <?php
                if (has_nav_menu('primary')) {
                    wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'menu_class'     => 'nav-menu',
                        'container'      => false,
                        'walker'         => new Amir_Ahmed_Nav_Walker(),
                    ));
                } else {
                    // Default menu if none is set
                    ?>
                    <ul class="nav-menu">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>">Home</a></li>
                        <li><a href="<?php echo esc_url(home_url('/about')); ?>">About</a></li>
                        <li><a href="<?php echo esc_url(home_url('/portfolio')); ?>">Portfolio</a></li>
                        <li><a href="<?php echo esc_url(home_url('/press-room')); ?>">Press Room</a></li>
                        <li><a href="<?php echo esc_url(home_url('/releases')); ?>">Releases</a></li>
                        <li><a href="<?php echo esc_url(home_url('/podcast')); ?>">Podcast</a></li>
                        <li><a href="<?php echo esc_url(home_url('/contact')); ?>">Contact</a></li>
                    </ul>
                    <?php
                }
                ?>

                <?php if ($show_header_cta && $header_cta_text) : ?>
                    <a href="<?php echo esc_url(home_url($header_cta_url)); ?>" class="btn btn-primary header-cta-btn">
                        <?php echo esc_html($header_cta_text); ?>
                    </a>
                <?php endif; ?>
            </nav>

            <!-- Mobile Menu Toggle -->
            <button class="menu-toggle" id="menu-toggle" aria-label="Toggle menu" aria-expanded="false">
                <span></span>
                <span></span>
                <span></span>
            </button>
        </div>
    </div>
</header>

<main id="main-content" class="site-main">
