<?php
/**
 * Front Page Template
 *
 * @package Amir_Ahmed
 */

get_header();

// Get customizer settings
$hero_tagline = get_theme_mod('hero_tagline', 'Interdisciplinary Artist');
$hero_title = get_theme_mod('hero_title', 'Interdisciplinary Artist & Creative Strategist');
$hero_description = get_theme_mod('hero_description', 'Amir Ahmed Omar Mohamed is an entrepreneur, interdisciplinary artist, and creative strategist based in the United Arab Emirates. Born in Dubai in 1993, Amir brings over 15 years of hands-on experience across content creation, storytelling, marketing, and creative production.');
$hero_image_id = get_theme_mod('hero_image');
?>

<!-- Hero Section -->
<section class="hero-section">
    <div class="hero-shapes">
        <div class="shape shape-1"></div>
        <div class="shape shape-2"></div>
    </div>
    <div class="container">
        <div class="hero-content">
            <div class="hero-text animate-fadeInUp">
                <p class="hero-tagline"><?php echo esc_html($hero_tagline); ?></p>
                <h1 class="hero-title">
                    <?php
                    $title_parts = explode('&', $hero_title);
                    echo esc_html($title_parts[0]);
                    if (isset($title_parts[1])) {
                        echo '<span>&' . esc_html($title_parts[1]) . '</span>';
                    }
                    ?>
                </h1>
                <p class="hero-description"><?php echo esc_html($hero_description); ?></p>
                <div class="hero-buttons">
                    <a href="<?php echo esc_url(home_url('/portfolio')); ?>" class="btn btn-primary">
                        View Portfolio
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>
                    </a>
                    <a href="<?php echo esc_url(home_url('/contact')); ?>" class="btn btn-outline">Get In Touch</a>
                </div>
            </div>
            <div class="hero-image animate-fadeInUp delay-2">
                <?php if ($hero_image_id) : ?>
                    <?php echo wp_get_attachment_image($hero_image_id, 'hero-image'); ?>
                <?php else : ?>
                    <div class="hero-placeholder" style="background: linear-gradient(135deg, var(--color-primary) 0%, #FFD700 100%); width: 100%; height: 600px; border-radius: 10px;"></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<!-- Services/Skills Section -->
<section class="section bg-gray">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle">What I Do</p>
            <h2 class="section-title">My Creative Services</h2>
            <p class="section-description">Blending art with strategy to create impactful results across multiple disciplines.</p>
        </div>
        <div class="services-grid">
            <div class="service-item animate-fadeInUp">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect><circle cx="8.5" cy="8.5" r="1.5"></circle><polyline points="21 15 16 10 5 21"></polyline></svg>
                </div>
                <h3 class="service-title">Photography</h3>
                <p>Capturing moments with a unique artistic vision and professional expertise.</p>
            </div>
            <div class="service-item animate-fadeInUp delay-1">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polygon points="23 7 16 12 23 17 23 7"></polygon><rect x="1" y="5" width="15" height="14" rx="2" ry="2"></rect></svg>
                </div>
                <h3 class="service-title">Videography</h3>
                <p>Creating compelling visual stories through professional video production.</p>
            </div>
            <div class="service-item animate-fadeInUp delay-2">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 19l7-7 3 3-7 7-3-3z"></path><path d="M18 13l-1.5-7.5L2 2l3.5 14.5L13 18l5-5z"></path><path d="M2 2l7.586 7.586"></path><circle cx="11" cy="11" r="2"></circle></svg>
                </div>
                <h3 class="service-title">Calligraphy</h3>
                <p>Arabic calligraphy artwork inspired by cultural heritage and modern design.</p>
            </div>
            <div class="service-item animate-fadeInUp delay-3">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 18V5l12-2v13"></path><circle cx="6" cy="18" r="3"></circle><circle cx="18" cy="16" r="3"></circle></svg>
                </div>
                <h3 class="service-title">Music Production</h3>
                <p>Hip-hop and music production bringing creative visions to life.</p>
            </div>
            <div class="service-item animate-fadeInUp delay-4">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M19 21l-7-5-7 5V5a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2z"></path></svg>
                </div>
                <h3 class="service-title">Branding</h3>
                <p>Strategic brand identity development and creative direction.</p>
            </div>
            <div class="service-item animate-fadeInUp delay-5">
                <div class="service-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 20h9"></path><path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4L16.5 3.5z"></path></svg>
                </div>
                <h3 class="service-title">Digital Marketing</h3>
                <p>Results-driven marketing strategies and content creation.</p>
            </div>
        </div>
    </div>
</section>

<!-- About Preview Section -->
<section class="section">
    <div class="container">
        <div class="about-content">
            <div class="about-image animate-fadeInUp">
                <?php if ($hero_image_id) : ?>
                    <?php echo wp_get_attachment_image($hero_image_id, 'large'); ?>
                <?php else : ?>
                    <div class="about-placeholder" style="background: var(--color-gray); width: 100%; height: 500px; border-radius: 10px;"></div>
                <?php endif; ?>
            </div>
            <div class="about-text animate-fadeInUp delay-2">
                <p class="section-subtitle">About Me</p>
                <h2>Creative Vision Meets Strategic Excellence</h2>
                <p>His work includes photography, filmmaking, Arabic calligraphy, Hip-hop & music production, podcasting, branding, and digital marketing. He blends art with strategy to create impactful results.</p>
                <p>Amir began his creative journey early, inspired by his father, a visual artist and Arabic calligrapher. By his teenage years, he had already mastered graphic design, photography, and visual storytelling, laying the groundwork for his diverse career.</p>
                <a href="<?php echo esc_url(home_url('/about')); ?>" class="btn btn-dark">Learn More About Me</a>
                <div class="about-stats">
                    <div class="stat-item">
                        <h3>15+</h3>
                        <p>Years Experience</p>
                    </div>
                    <div class="stat-item">
                        <h3>100+</h3>
                        <p>Projects Completed</p>
                    </div>
                    <div class="stat-item">
                        <h3>50+</h3>
                        <p>Happy Clients</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Portfolio Preview -->
<section class="section section-dark">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle">My Work</p>
            <h2 class="section-title">Featured Projects</h2>
            <p class="section-description" style="color: rgba(255,255,255,0.7);">A selection of my recent work across photography, videography, and calligraphy.</p>
        </div>

        <?php
        $portfolio_query = new WP_Query(array(
            'post_type'      => 'portfolio',
            'posts_per_page' => 6,
            'orderby'        => 'date',
            'order'          => 'DESC',
        ));

        if ($portfolio_query->have_posts()) :
        ?>
        <div class="portfolio-grid">
            <?php while ($portfolio_query->have_posts()) : $portfolio_query->the_post(); ?>
            <div class="portfolio-item animate-fadeInUp">
                <?php if (has_post_thumbnail()) : ?>
                    <?php the_post_thumbnail('portfolio-thumb'); ?>
                <?php else : ?>
                    <div style="background: linear-gradient(135deg, var(--color-primary) 0%, #333 100%); width: 100%; height: 300px;"></div>
                <?php endif; ?>
                <div class="portfolio-overlay">
                    <?php
                    $categories = get_the_terms(get_the_ID(), 'portfolio_category');
                    if ($categories && !is_wp_error($categories)) :
                    ?>
                    <span class="portfolio-category"><?php echo esc_html($categories[0]->name); ?></span>
                    <?php endif; ?>
                    <h3 class="portfolio-title"><?php the_title(); ?></h3>
                </div>
                <a href="<?php the_permalink(); ?>" class="portfolio-link"></a>
            </div>
            <?php endwhile; ?>
        </div>
        <?php
        wp_reset_postdata();
        else :
        ?>
        <!-- Placeholder portfolio items -->
        <div class="portfolio-grid">
            <?php for ($i = 1; $i <= 6; $i++) : ?>
            <div class="portfolio-item animate-fadeInUp">
                <div style="background: linear-gradient(135deg, var(--color-primary) <?php echo ($i * 10); ?>%, #333 100%); width: 100%; height: 300px;"></div>
                <div class="portfolio-overlay">
                    <span class="portfolio-category">Photography</span>
                    <h3 class="portfolio-title">Project <?php echo $i; ?></h3>
                </div>
            </div>
            <?php endfor; ?>
        </div>
        <?php endif; ?>

        <div class="text-center mt-5">
            <a href="<?php echo esc_url(home_url('/portfolio')); ?>" class="btn btn-primary">View All Projects</a>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="section section-yellow">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle" style="color: var(--color-dark);">Testimonials</p>
            <h2 class="section-title">What Clients Say</h2>
        </div>

        <div class="testimonials-slider">
            <?php
            $testimonials_query = new WP_Query(array(
                'post_type'      => 'testimonial',
                'posts_per_page' => 1,
            ));

            if ($testimonials_query->have_posts()) :
                while ($testimonials_query->have_posts()) : $testimonials_query->the_post();
            ?>
            <div class="testimonial-item">
                <p class="testimonial-text">"<?php echo esc_html(get_the_content()); ?>"</p>
                <div class="testimonial-author">
                    <?php if (has_post_thumbnail()) : ?>
                        <?php the_post_thumbnail('thumbnail'); ?>
                    <?php endif; ?>
                    <div class="author-info">
                        <h4><?php the_title(); ?></h4>
                        <p><?php echo esc_html(get_the_excerpt()); ?></p>
                    </div>
                </div>
            </div>
            <?php
                endwhile;
                wp_reset_postdata();
            else :
            ?>
            <div class="testimonial-item">
                <p class="testimonial-text">"Clients choose results not promises. We turn bold strategies into measurable impact. Strategy built to deliver, not decorate."</p>
                <div class="testimonial-author">
                    <div class="author-info">
                        <h4>Client Testimonial</h4>
                        <p>Creative Director</p>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Latest News/Updates -->
<section class="section">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle">Press Room</p>
            <h2 class="section-title">Latest Updates</h2>
            <p class="section-description">Stay updated with the latest news, articles, and updates.</p>
        </div>

        <?php
        $posts_query = new WP_Query(array(
            'post_type'      => 'post',
            'posts_per_page' => 3,
        ));

        if ($posts_query->have_posts()) :
        ?>
        <div class="posts-grid">
            <?php while ($posts_query->have_posts()) : $posts_query->the_post(); ?>
            <article class="post-card animate-fadeInUp">
                <div class="post-image">
                    <?php if (has_post_thumbnail()) : ?>
                        <?php the_post_thumbnail('post-thumb'); ?>
                    <?php else : ?>
                        <div style="background: var(--color-gray); width: 100%; height: 100%;"></div>
                    <?php endif; ?>
                </div>
                <div class="post-content">
                    <div class="post-meta">
                        <span><?php echo get_the_date(); ?></span>
                        <span><?php the_category(', '); ?></span>
                    </div>
                    <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    <p class="post-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 15); ?></p>
                    <a href="<?php the_permalink(); ?>" class="read-more">Read More</a>
                </div>
            </article>
            <?php endwhile; ?>
        </div>
        <?php
        wp_reset_postdata();
        else :
        ?>
        <div class="posts-grid">
            <?php for ($i = 1; $i <= 3; $i++) : ?>
            <article class="post-card animate-fadeInUp">
                <div class="post-image">
                    <div style="background: var(--color-gray); width: 100%; height: 220px;"></div>
                </div>
                <div class="post-content">
                    <div class="post-meta">
                        <span>January <?php echo $i; ?>, 2026</span>
                        <span>News</span>
                    </div>
                    <h3 class="post-title"><a href="#">Latest Update <?php echo $i; ?></a></h3>
                    <p class="post-excerpt">Stay tuned for the latest updates and news from Amir Ahmed.</p>
                    <a href="#" class="read-more">Read More</a>
                </div>
            </article>
            <?php endfor; ?>
        </div>
        <?php endif; ?>

        <div class="text-center mt-5">
            <a href="<?php echo esc_url(home_url('/press-room')); ?>" class="btn btn-outline">View All Updates</a>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="section section-dark">
    <div class="container text-center">
        <h2 class="section-title mb-3">Ready to Start a Project?</h2>
        <p class="section-description mb-4" style="color: rgba(255,255,255,0.7); max-width: 600px; margin-left: auto; margin-right: auto;">Let's collaborate and bring your creative vision to life. Get in touch to discuss your next project.</p>
        <a href="<?php echo esc_url(home_url('/contact')); ?>" class="btn btn-primary">Get In Touch</a>
    </div>
</section>

<?php get_footer(); ?>
