</main><!-- #main-content -->

<?php
// Get footer customizer settings
$footer_logo_text_line1 = get_theme_mod('footer_logo_text_line1', 'AMIR');
$footer_logo_text_line2 = get_theme_mod('footer_logo_text_line2', 'AHMED');
$footer_description     = get_theme_mod('footer_description', 'Interdisciplinary Artist & Creative Strategist based in the United Arab Emirates. Blending art with strategy to create impactful results.');
$show_footer_social     = get_theme_mod('show_footer_social', true);
$footer_logo_icon       = get_theme_mod('footer_logo_icon_image');

// Footer Column Titles
$footer_col1_title = get_theme_mod('footer_col1_title', 'Quick Links');
$footer_col2_title = get_theme_mod('footer_col2_title', 'Services');
$footer_col3_title = get_theme_mod('footer_col3_title', 'Contact');

// Footer Bottom Settings
$footer_copyright   = get_theme_mod('footer_copyright', '© {year} Amir Ahmed. All rights reserved.');
$footer_bottom_text = get_theme_mod('footer_bottom_text', 'Designed with passion');
$show_back_to_top   = get_theme_mod('show_back_to_top', true);

// Build Quick Links array from customizer
$quick_links = array();
for ($i = 1; $i <= 6; $i++) {
    $link_text = get_theme_mod('footer_link' . $i . '_text', '');
    $link_url  = get_theme_mod('footer_link' . $i . '_url', '');
    if (!empty($link_text)) {
        $quick_links[] = array(
            'text' => $link_text,
            'url'  => $link_url,
        );
    }
}

// Default quick links if none set
if (empty($quick_links)) {
    $quick_links = array(
        array('text' => 'About', 'url' => '/about'),
        array('text' => 'Portfolio', 'url' => '/portfolio'),
        array('text' => 'Press Room', 'url' => '/press-room'),
        array('text' => 'Contact', 'url' => '/contact'),
    );
}

// Build Services array from customizer
$services = array();
for ($i = 1; $i <= 6; $i++) {
    $service_text = get_theme_mod('footer_service' . $i . '_text', '');
    $service_url  = get_theme_mod('footer_service' . $i . '_url', '');
    if (!empty($service_text)) {
        $services[] = array(
            'text' => $service_text,
            'url'  => $service_url,
        );
    }
}

// Default services if none set
if (empty($services)) {
    $services = array(
        array('text' => 'Photography', 'url' => '/portfolio/?category=photography'),
        array('text' => 'Videography', 'url' => '/portfolio/?category=videography'),
        array('text' => 'Calligraphy', 'url' => '/portfolio/?category=calligraphy'),
        array('text' => 'Music', 'url' => '/releases'),
    );
}

// Contact Info
$footer_email    = get_theme_mod('footer_email', get_theme_mod('contact_email', 'hello@amirahmed.com'));
$footer_phone    = get_theme_mod('footer_phone', get_theme_mod('contact_phone', ''));
$footer_location = get_theme_mod('footer_location', get_theme_mod('contact_location', 'Dubai, United Arab Emirates'));
$footer_hours    = get_theme_mod('footer_business_hours', '');

// Process copyright year placeholder
$footer_copyright = str_replace('{year}', date('Y'), $footer_copyright);
?>

<footer class="site-footer">
    <div class="container">
        <div class="footer-content">
            <!-- About Column -->
            <div class="footer-about">
                <a href="<?php echo esc_url(home_url('/')); ?>" class="site-logo">
                    <div class="logo-icon">
                        <?php if ($footer_logo_icon) : ?>
                            <?php echo wp_get_attachment_image($footer_logo_icon, 'thumbnail'); ?>
                        <?php else : ?>
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 100 100" fill="#FFEB66">
                                <path d="M50 0L58 42L100 50L58 58L50 100L42 58L0 50L42 42Z"/>
                            </svg>
                        <?php endif; ?>
                    </div>
                    <?php if ($footer_logo_text_line1 || $footer_logo_text_line2) : ?>
                        <div class="logo-text">
                            <?php if ($footer_logo_text_line1) : ?>
                                <strong><?php echo esc_html($footer_logo_text_line1); ?></strong>
                            <?php endif; ?>
                            <?php if ($footer_logo_text_line2) : ?>
                                <span><?php echo esc_html($footer_logo_text_line2); ?></span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </a>
                <?php if ($footer_description) : ?>
                    <p><?php echo esc_html($footer_description); ?></p>
                <?php endif; ?>
                <?php if ($show_footer_social) : ?>
                    <?php amir_ahmed_social_links(); ?>
                <?php endif; ?>
            </div>

            <!-- Quick Links Column -->
            <?php if (!empty($quick_links)) : ?>
            <div class="footer-widget">
                <h4 class="footer-title"><?php echo esc_html($footer_col1_title); ?></h4>
                <ul class="footer-links">
                    <?php foreach ($quick_links as $link) : ?>
                        <?php if (!empty($link['text'])) : ?>
                        <li>
                            <?php if (!empty($link['url'])) : ?>
                                <a href="<?php echo esc_url(home_url($link['url'])); ?>"><?php echo esc_html($link['text']); ?></a>
                            <?php else : ?>
                                <span><?php echo esc_html($link['text']); ?></span>
                            <?php endif; ?>
                        </li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>

            <!-- Services Column -->
            <?php if (!empty($services)) : ?>
            <div class="footer-widget">
                <h4 class="footer-title"><?php echo esc_html($footer_col2_title); ?></h4>
                <ul class="footer-links">
                    <?php foreach ($services as $service) : ?>
                        <?php if (!empty($service['text'])) : ?>
                        <li>
                            <?php if (!empty($service['url'])) : ?>
                                <a href="<?php echo esc_url(home_url($service['url'])); ?>"><?php echo esc_html($service['text']); ?></a>
                            <?php else : ?>
                                <span><?php echo esc_html($service['text']); ?></span>
                            <?php endif; ?>
                        </li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>

            <!-- Contact Column -->
            <div class="footer-widget">
                <h4 class="footer-title"><?php echo esc_html($footer_col3_title); ?></h4>
                <ul class="footer-links footer-contact-info">
                    <?php if ($footer_email) : ?>
                    <li class="contact-item">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="2" y="4" width="20" height="16" rx="2"></rect><path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path></svg>
                        <a href="mailto:<?php echo esc_attr($footer_email); ?>"><?php echo esc_html($footer_email); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php if ($footer_phone) : ?>
                    <li class="contact-item">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>
                        <a href="tel:<?php echo esc_attr(preg_replace('/[^0-9+]/', '', $footer_phone)); ?>"><?php echo esc_html($footer_phone); ?></a>
                    </li>
                    <?php endif; ?>
                    <?php if ($footer_location) : ?>
                    <li class="contact-item">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M20 10c0 6-8 12-8 12s-8-6-8-12a8 8 0 0 1 16 0Z"></path><circle cx="12" cy="10" r="3"></circle></svg>
                        <span><?php echo esc_html($footer_location); ?></span>
                    </li>
                    <?php endif; ?>
                    <?php if ($footer_hours) : ?>
                    <li class="contact-item">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                        <span><?php echo esc_html($footer_hours); ?></span>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

        <div class="footer-bottom">
            <p><?php echo wp_kses_post($footer_copyright); ?></p>
            <?php if ($footer_bottom_text) : ?>
                <p><?php echo esc_html($footer_bottom_text); ?></p>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($show_back_to_top) : ?>
    <button class="back-to-top" id="back-to-top" aria-label="Back to top">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="12" y1="19" x2="12" y2="5"></line><polyline points="5 12 12 5 19 12"></polyline></svg>
    </button>
    <?php endif; ?>
</footer>

<?php wp_footer(); ?>
</body>
</html>
