<?php
/**
 * Releases Archive Template
 *
 * @package Amir_Ahmed
 */

get_header();
?>

<header class="page-header">
    <div class="container">
        <h1 class="page-title">Music <span>Releases</span></h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<section class="section">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle">Listen Now</p>
            <h2 class="section-title">My Tracks</h2>
            <p class="section-description">Explore my music releases and productions.</p>
        </div>

        <?php if (have_posts()) : ?>
        <div class="tracks-list">
            <?php $track_number = 1; ?>
            <?php while (have_posts()) : the_post(); ?>
            <div class="track-item">
                <span class="track-number"><?php echo str_pad($track_number, 2, '0', STR_PAD_LEFT); ?></span>
                <div class="track-play">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>
                </div>
                <div class="track-info">
                    <h4 class="track-title"><?php the_title(); ?></h4>
                    <span class="track-artist">Amir Ahmed</span>
                </div>
                <span class="track-duration"><?php echo esc_html(get_post_meta(get_the_ID(), 'track_duration', true) ?: '3:45'); ?></span>
            </div>
            <?php $track_number++; ?>
            <?php endwhile; ?>
        </div>
        <?php else : ?>
        <!-- Placeholder Tracks -->
        <div class="tracks-list">
            <?php
            $placeholder_tracks = array(
                array('title' => 'Track One', 'duration' => '3:45'),
                array('title' => 'Track Two', 'duration' => '4:12'),
                array('title' => 'Track Three', 'duration' => '3:28'),
                array('title' => 'Track Four', 'duration' => '5:01'),
                array('title' => 'Track Five', 'duration' => '3:55'),
            );

            foreach ($placeholder_tracks as $index => $track) :
            ?>
            <div class="track-item">
                <span class="track-number"><?php echo str_pad($index + 1, 2, '0', STR_PAD_LEFT); ?></span>
                <div class="track-play">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>
                </div>
                <div class="track-info">
                    <h4 class="track-title"><?php echo esc_html($track['title']); ?></h4>
                    <span class="track-artist">Amir Ahmed</span>
                </div>
                <span class="track-duration"><?php echo esc_html($track['duration']); ?></span>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <!-- Streaming Platforms -->
        <div class="streaming-platforms text-center mt-5">
            <h3 class="mb-3">Listen On</h3>
            <div class="platform-links d-flex justify-center" style="gap: 20px; flex-wrap: wrap;">
                <a href="#" class="btn btn-outline">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.419 1.56-.299.421-1.02.599-1.559.3z"/></svg>
                    Spotify
                </a>
                <a href="#" class="btn btn-outline">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M18.71 19.5c-.83 1.24-1.71 2.45-3.05 2.47-1.34.03-1.77-.79-3.29-.79-1.53 0-2 .77-3.27.82-1.31.05-2.3-1.32-3.14-2.53C4.25 17 2.94 12.45 4.7 9.39c.87-1.52 2.43-2.48 4.12-2.51 1.28-.02 2.5.87 3.29.87.78 0 2.26-1.07 3.81-.91.65.03 2.47.26 3.64 1.98-.09.06-2.17 1.28-2.15 3.81.03 3.02 2.65 4.03 2.68 4.04-.03.07-.42 1.44-1.38 2.83M13 3.5c.73-.83 1.94-1.46 2.94-1.5.13 1.17-.34 2.35-1.04 3.19-.69.85-1.83 1.51-2.95 1.42-.15-1.15.41-2.35 1.05-3.11z"/></svg>
                    Apple Music
                </a>
                <a href="#" class="btn btn-outline">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.007 2.007 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.007 2.007 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31.4 31.4 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.007 2.007 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A99.788 99.788 0 0 1 7.858 2h.193zM6.4 5.209v4.818l4.157-2.408L6.4 5.209z"/></svg>
                    YouTube Music
                </a>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>
