<?php
/**
 * Portfolio Archive Template
 *
 * @package Amir_Ahmed
 */

get_header();

// Get portfolio categories
$portfolio_categories = get_terms(array(
    'taxonomy'   => 'portfolio_category',
    'hide_empty' => true,
));
?>

<header class="page-header">
    <div class="container">
        <h1 class="page-title">My <span>Portfolio</span></h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<section class="section">
    <div class="container">
        <!-- Portfolio Filter -->
        <?php if (!empty($portfolio_categories) && !is_wp_error($portfolio_categories)) : ?>
        <div class="portfolio-filter">
            <button class="filter-btn active" data-filter="all">All</button>
            <?php foreach ($portfolio_categories as $category) : ?>
            <button class="filter-btn" data-filter="<?php echo esc_attr($category->slug); ?>">
                <?php echo esc_html($category->name); ?>
            </button>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <!-- Portfolio Grid -->
        <?php if (have_posts()) : ?>
        <div class="portfolio-grid" id="portfolio-grid">
            <?php while (have_posts()) : the_post();
                $categories = get_the_terms(get_the_ID(), 'portfolio_category');
                $category_slugs = '';
                $category_name = '';
                if ($categories && !is_wp_error($categories)) {
                    $category_slugs = implode(' ', wp_list_pluck($categories, 'slug'));
                    $category_name = $categories[0]->name;
                }
            ?>
            <div class="portfolio-item animate-fadeInUp" data-category="<?php echo esc_attr($category_slugs); ?>">
                <?php if (has_post_thumbnail()) : ?>
                    <?php the_post_thumbnail('portfolio-thumb'); ?>
                <?php else : ?>
                    <div style="background: linear-gradient(135deg, var(--color-primary) 0%, #333 100%); width: 100%; height: 300px;"></div>
                <?php endif; ?>
                <div class="portfolio-overlay">
                    <?php if ($category_name) : ?>
                    <span class="portfolio-category"><?php echo esc_html($category_name); ?></span>
                    <?php endif; ?>
                    <h3 class="portfolio-title"><?php the_title(); ?></h3>
                </div>
                <a href="<?php the_permalink(); ?>" class="portfolio-link" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 10;"></a>
            </div>
            <?php endwhile; ?>
        </div>

        <!-- Pagination -->
        <div class="pagination mt-5">
            <?php
            the_posts_pagination(array(
                'mid_size'  => 2,
                'prev_text' => '&laquo; Previous',
                'next_text' => 'Next &raquo;',
            ));
            ?>
        </div>

        <?php else : ?>
        <!-- Placeholder Portfolio Items -->
        <div class="portfolio-grid" id="portfolio-grid">
            <?php
            $placeholder_items = array(
                array('title' => 'Photography Project', 'category' => 'photography'),
                array('title' => 'Video Production', 'category' => 'videography'),
                array('title' => 'Arabic Calligraphy', 'category' => 'calligraphy'),
                array('title' => 'Brand Identity', 'category' => 'photography'),
                array('title' => 'Documentary Film', 'category' => 'videography'),
                array('title' => 'Modern Calligraphy', 'category' => 'calligraphy'),
            );

            foreach ($placeholder_items as $index => $item) :
            ?>
            <div class="portfolio-item animate-fadeInUp" data-category="<?php echo esc_attr($item['category']); ?>">
                <div style="background: linear-gradient(135deg, var(--color-primary) <?php echo ($index * 15); ?>%, #333 100%); width: 100%; height: 300px;"></div>
                <div class="portfolio-overlay">
                    <span class="portfolio-category"><?php echo esc_html(ucfirst($item['category'])); ?></span>
                    <h3 class="portfolio-title"><?php echo esc_html($item['title']); ?></h3>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- CTA Section -->
<section class="section section-dark">
    <div class="container text-center">
        <h2 class="section-title mb-3">Interested in Working Together?</h2>
        <p class="section-description mb-4" style="color: rgba(255,255,255,0.7); max-width: 600px; margin-left: auto; margin-right: auto;">Let's discuss your next creative project and bring your vision to life.</p>
        <a href="<?php echo esc_url(home_url('/contact')); ?>" class="btn btn-primary">Get In Touch</a>
    </div>
</section>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const filterBtns = document.querySelectorAll('.filter-btn');
    const portfolioItems = document.querySelectorAll('.portfolio-item');

    filterBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            filterBtns.forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');

            const filter = this.getAttribute('data-filter');

            portfolioItems.forEach(item => {
                if (filter === 'all' || item.getAttribute('data-category').includes(filter)) {
                    item.style.display = 'block';
                    item.style.opacity = '1';
                } else {
                    item.style.opacity = '0';
                    setTimeout(() => {
                        item.style.display = 'none';
                    }, 300);
                }
            });
        });
    });
});
</script>

<?php get_footer(); ?>
