<?php
/**
 * Podcast Archive Template
 *
 * @package Amir_Ahmed
 */

get_header();
?>

<header class="page-header">
    <div class="container">
        <h1 class="page-title">My <span>Podcast</span></h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<section class="section">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle">Listen & Learn</p>
            <h2 class="section-title">Podcast Episodes</h2>
            <p class="section-description">Conversations about creativity, strategy, and the art of building impactful brands.</p>
        </div>

        <?php if (have_posts()) : ?>
        <div class="podcast-episodes">
            <?php $episode_number = 1; ?>
            <?php while (have_posts()) : the_post(); ?>
            <article class="podcast-episode">
                <div class="episode-image">
                    <?php if (has_post_thumbnail()) : ?>
                        <?php the_post_thumbnail('medium'); ?>
                    <?php else : ?>
                        <div style="background: var(--color-dark); width: 100%; height: 100%; display: flex; align-items: center; justify-content: center;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="#FFEB66" stroke-width="2"><path d="M12 1a3 3 0 0 0-3 3v8a3 3 0 0 0 6 0V4a3 3 0 0 0-3-3z"></path><path d="M19 10v2a7 7 0 0 1-14 0v-2"></path><line x1="12" y1="19" x2="12" y2="23"></line><line x1="8" y1="23" x2="16" y2="23"></line></svg>
                        </div>
                    <?php endif; ?>
                    <div class="episode-play">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="currentColor"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>
                    </div>
                </div>
                <div class="episode-content">
                    <div class="episode-meta">
                        <span class="episode-number">Episode <?php echo $episode_number; ?></span>
                        <span class="episode-date"><?php echo get_the_date(); ?></span>
                        <span class="episode-duration"><?php echo esc_html(get_post_meta(get_the_ID(), 'episode_duration', true) ?: '45 min'); ?></span>
                    </div>
                    <h3 class="episode-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h3>
                    <p class="episode-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 25); ?></p>
                    <a href="<?php the_permalink(); ?>" class="btn btn-outline" style="padding: 10px 20px; font-size: 0.85rem;">Listen Now</a>
                </div>
            </article>
            <?php $episode_number++; ?>
            <?php endwhile; ?>
        </div>

        <!-- Pagination -->
        <div class="pagination mt-5">
            <?php
            the_posts_pagination(array(
                'mid_size'  => 2,
                'prev_text' => '&laquo; Previous',
                'next_text' => 'Next &raquo;',
            ));
            ?>
        </div>

        <?php else : ?>
        <!-- Placeholder Episodes -->
        <div class="podcast-episodes">
            <?php
            $placeholder_episodes = array(
                array('title' => 'The Art of Creative Strategy', 'duration' => '45 min'),
                array('title' => 'Building Brands with Purpose', 'duration' => '52 min'),
                array('title' => 'From Vision to Reality', 'duration' => '38 min'),
                array('title' => 'The Power of Storytelling', 'duration' => '41 min'),
            );

            foreach ($placeholder_episodes as $index => $episode) :
            ?>
            <article class="podcast-episode">
                <div class="episode-image">
                    <div style="background: var(--color-dark); width: 100%; height: 100%; display: flex; align-items: center; justify-content: center;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="#FFEB66" stroke-width="2"><path d="M12 1a3 3 0 0 0-3 3v8a3 3 0 0 0 6 0V4a3 3 0 0 0-3-3z"></path><path d="M19 10v2a7 7 0 0 1-14 0v-2"></path><line x1="12" y1="19" x2="12" y2="23"></line><line x1="8" y1="23" x2="16" y2="23"></line></svg>
                    </div>
                    <div class="episode-play">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="currentColor"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>
                    </div>
                </div>
                <div class="episode-content">
                    <div class="episode-meta">
                        <span class="episode-number">Episode <?php echo $index + 1; ?></span>
                        <span class="episode-date">January <?php echo $index + 1; ?>, 2026</span>
                        <span class="episode-duration"><?php echo esc_html($episode['duration']); ?></span>
                    </div>
                    <h3 class="episode-title">
                        <a href="#"><?php echo esc_html($episode['title']); ?></a>
                    </h3>
                    <p class="episode-excerpt">Join me as we explore the intersection of creativity and strategy in this insightful episode.</p>
                    <a href="#" class="btn btn-outline" style="padding: 10px 20px; font-size: 0.85rem;">Listen Now</a>
                </div>
            </article>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <!-- Subscribe Section -->
        <div class="podcast-subscribe text-center mt-5" style="background: var(--color-gray); padding: 50px; border-radius: 10px;">
            <h3 class="mb-3">Subscribe to the Podcast</h3>
            <p class="mb-4">Never miss an episode. Subscribe on your favorite platform.</p>
            <div class="platform-links d-flex justify-center" style="gap: 20px; flex-wrap: wrap;">
                <a href="#" class="btn btn-dark">Apple Podcasts</a>
                <a href="#" class="btn btn-dark">Spotify</a>
                <a href="#" class="btn btn-dark">Google Podcasts</a>
            </div>
        </div>
    </div>
</section>

<style>
.podcast-episodes {
    display: flex;
    flex-direction: column;
    gap: 30px;
}

.podcast-episode {
    display: grid;
    grid-template-columns: 200px 1fr;
    gap: 30px;
    background: var(--color-white);
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
    transition: var(--transition);
}

.podcast-episode:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
}

.episode-image {
    width: 200px;
    height: 200px;
    position: relative;
    overflow: hidden;
}

.episode-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.episode-play {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 60px;
    height: 60px;
    background: var(--color-primary);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    opacity: 0;
    transition: var(--transition);
}

.podcast-episode:hover .episode-play {
    opacity: 1;
}

.episode-content {
    padding: 30px 30px 30px 0;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.episode-meta {
    display: flex;
    gap: 20px;
    font-size: 0.85rem;
    color: var(--color-gray-dark);
    margin-bottom: 10px;
}

.episode-number {
    color: var(--color-primary);
    font-weight: 600;
}

.episode-title {
    font-size: 1.4rem;
    margin-bottom: 10px;
}

.episode-title a:hover {
    color: var(--color-primary);
}

.episode-excerpt {
    color: var(--color-gray-dark);
    margin-bottom: 20px;
}

@media (max-width: 768px) {
    .podcast-episode {
        grid-template-columns: 1fr;
    }

    .episode-image {
        width: 100%;
        height: 200px;
    }

    .episode-content {
        padding: 0 20px 20px;
    }
}
</style>

<?php get_footer(); ?>
