<?php
/**
 * Downloads Archive Template
 *
 * @package Amir_Ahmed
 */

get_header();
?>

<header class="page-header">
    <div class="container">
        <h1 class="page-title">Digital <span>Downloads</span></h1>
        <?php amir_ahmed_breadcrumb(); ?>
    </div>
</header>

<section class="section">
    <div class="container">
        <div class="section-header">
            <p class="section-subtitle">Resources</p>
            <h2 class="section-title">Free Downloads</h2>
            <p class="section-description">Download free resources, templates, and digital products.</p>
        </div>

        <?php if (have_posts()) : ?>
        <div class="downloads-grid">
            <?php while (have_posts()) : the_post(); ?>
            <div class="download-item animate-fadeInUp">
                <div class="download-icon">
                    <?php if (has_post_thumbnail()) : ?>
                        <?php the_post_thumbnail('thumbnail'); ?>
                    <?php else : ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>
                    <?php endif; ?>
                </div>
                <h3 class="download-title"><?php the_title(); ?></h3>
                <p class="download-description"><?php echo wp_trim_words(get_the_excerpt(), 15); ?></p>
                <?php
                $download_url = get_post_meta(get_the_ID(), 'download_url', true);
                if ($download_url) :
                ?>
                <a href="<?php echo esc_url($download_url); ?>" class="btn btn-primary" target="_blank">
                    Download
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>
                </a>
                <?php else : ?>
                <a href="<?php the_permalink(); ?>" class="btn btn-outline">Learn More</a>
                <?php endif; ?>
            </div>
            <?php endwhile; ?>
        </div>
        <?php else : ?>
        <!-- Placeholder Downloads -->
        <div class="downloads-grid">
            <?php
            $placeholder_downloads = array(
                array('title' => 'Brand Guidelines PDF', 'desc' => 'Complete brand guidelines and usage instructions.'),
                array('title' => 'Logo Package', 'desc' => 'All logo variations in multiple formats.'),
                array('title' => 'Social Media Templates', 'desc' => 'Ready-to-use templates for social media.'),
            );

            foreach ($placeholder_downloads as $download) :
            ?>
            <div class="download-item animate-fadeInUp">
                <div class="download-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>
                </div>
                <h3 class="download-title"><?php echo esc_html($download['title']); ?></h3>
                <p class="download-description"><?php echo esc_html($download['desc']); ?></p>
                <a href="#" class="btn btn-outline">Coming Soon</a>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

<?php get_footer(); ?>
