<?php
/**
 * 404 Error Page Template
 *
 * @package Amir_Ahmed
 */

get_header();
?>

<section class="error-404 section" style="min-height: 60vh; display: flex; align-items: center;">
    <div class="container text-center">
        <h1 style="font-size: 8rem; color: var(--color-primary); margin-bottom: 20px;">404</h1>
        <h2 class="mb-3">Page Not Found</h2>
        <p class="mb-4" style="max-width: 500px; margin: 0 auto 30px; color: var(--color-gray-dark);">
            Oops! The page you're looking for doesn't exist. It might have been moved or deleted.
        </p>
        <div class="error-actions">
            <a href="<?php echo esc_url(home_url('/')); ?>" class="btn btn-primary">
                Back to Home
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>
            </a>
            <a href="<?php echo esc_url(home_url('/contact')); ?>" class="btn btn-outline">Contact Us</a>
        </div>
    </div>
</section>

<?php get_footer(); ?>
