<?php
/**
 * Database Setup Script
 * Run this file once to create the database
 * Delete after use for security
 */

$host = 'localhost';
$user = 'root';
$pass = '1234';
$dbname = 'amersite_db';

echo "<h2>Amir Ahmed Website - Database Setup</h2>";

try {
    // Connect without database
    $conn = new mysqli($host, $user, $pass);

    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }

    // Create database
    $sql = "CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
    if ($conn->query($sql) === TRUE) {
        echo "<p style='color: green;'>Database '$dbname' created successfully (or already exists).</p>";
    } else {
        throw new Exception("Error creating database: " . $conn->error);
    }

    $conn->close();

    echo "<h3>Next Steps:</h3>";
    echo "<ol>";
    echo "<li>Go to <a href='wp-admin/install.php'>WordPress Installation</a></li>";
    echo "<li>Complete the WordPress setup wizard</li>";
    echo "<li>Go to Appearance > Themes and activate 'Amir Ahmed' theme</li>";
    echo "<li>Create the following pages: Home, About, Portfolio, Press Room, Releases, Podcast, Downloads, Contact</li>";
    echo "<li>Set 'Home' as your static front page in Settings > Reading</li>";
    echo "<li>Assign page templates: About page = 'About Page', Contact page = 'Contact Page'</li>";
    echo "<li>Create menus in Appearance > Menus</li>";
    echo "<li><strong>Delete this setup-db.php file for security!</strong></li>";
    echo "</ol>";

    echo "<p><strong>Important:</strong> Delete this file after setup is complete!</p>";
    echo "<p><a href='wp-admin/install.php' class='button' style='display: inline-block; padding: 15px 30px; background: #FFEB66; color: #1D1A1A; text-decoration: none; border-radius: 5px; font-weight: bold;'>Start WordPress Installation</a></p>";

} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
    echo "<p>Make sure XAMPP MySQL is running and the credentials are correct.</p>";
}
?>

<style>
body {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    max-width: 800px;
    margin: 50px auto;
    padding: 20px;
    line-height: 1.6;
}
h2 {
    color: #1D1A1A;
}
li {
    margin-bottom: 10px;
}
</style>
